#include "FTPServer.h"
#include "xboxtools.h"

CFTPServer::CFTPServer(void)
{
}

CFTPServer::~CFTPServer(void)
{
}

void CFTPServer::TestSocket()
{
}

unsigned long CFTPServer::Process(void* parameter)
{
	SOCKET server;

	sockaddr_in local;
	local.sin_family=AF_INET;
	local.sin_addr.s_addr=INADDR_ANY;
	local.sin_port=htons((u_short)port);

    XferPortStart = XferPortRange = XferPort = 0;

	server=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);

	if(server==INVALID_SOCKET)
	{
		FTPMsg( "INVALID SOCKET!");
		return 0;
	}

	// after setting these undocumented flags on a socket they should then run unencrypted
	BOOL bBroadcast = TRUE;

	if( setsockopt(server, SOL_SOCKET, 0x5802, (PCSTR)&bBroadcast, sizeof(BOOL) ) != 0 )//PATCHED!
	{
		FTPMsg( "Failed to set socket to 5802, error");
		return 0;
	}

	if( setsockopt(server, SOL_SOCKET, 0x5801, (PCSTR)&bBroadcast, sizeof(BOOL) ) != 0 )//PATCHED!
	{
		FTPMsg( "Failed to set socket to 5801, error");
		return 0;
	}

	if ( bind( server, (const sockaddr*)&local, sizeof(local) ) == SOCKET_ERROR )
	{
		int Error = WSAGetLastError();
		FTPMsg("bind error %d",Error);
		return 0; 
	}

	while ( listen( server, SOMAXCONN ) != SOCKET_ERROR )
	{
		SOCKET client;
		int length;

		length = sizeof(local);
		//FTPMsg("Trying accept");
		client = accept( server, (sockaddr*)&local, &length );

		CFTPServerConn* conn = new CFTPServerConn();
		conn->CommandSocket = client;
		conn->XferPort = XferPort;
		conn->xboxip = xboxip;
        PortsUsed[XferPort] = 1;

		Conns.push_back(conn);

		conn->CreateThread();
		SetThreadPriority(conn->hThread,THREAD_PRIORITY_HIGHEST);

        // Cycle through port numbers.
        XferPort = XferPortStart;
        for(;XferPort < XferPortRange;XferPort++){
            // Find an unused port numbeer 
            // This code only relevant if a port range was specified.
            if (!PortsUsed[XferPort & 255]) break;
        }
	}

	return 0;
}